#include "winxy.h"
#include <QApplication>
#include <QIcon>

int main(int argc, char *argv[])
{
    // Ensure high DPI scaling is handled correctly
    QApplication::setHighDpiScaleFactorRoundingPolicy(Qt::HighDpiScaleFactorRoundingPolicy::PassThrough);

    QApplication a(argc, argv);

    // [NEW] Initialize Resource Discovery immediately on startup
    // This finds the "figures" folder and sets the project root path
    AppConfig::initialize();

    // Set Application Metadata (Publisher & Version)
    a.setApplicationName("WinXY Toolkit");
    a.setApplicationVersion("1.0");
    a.setOrganizationName("Void Mutsumi");
    a.setOrganizationDomain("xuda-ye.com");

    // [NEW] Store Feedback/Contact info as a dynamic property
    a.setProperty("FeedbackEmail", "abneryepku@outlook.com");

    // Set global font
    QFont font("Segoe UI", 10);
    a.setFont(font);

    WinXY w;
    w.show();
    return a.exec();
}
